//
//  AuroraModel.h
//  
//
//  Created by San Byn Nguyen on 09.08.2023.
//

#ifndef Header_h
#define Header_h

// IMPORTANT: Keep in sync with Swift enum AuroraType (rawValue: UInt8, starting from 10)
typedef enum {
    SmartCare = 10,
    Protection = 11,
    Performance = 12,
    Junk = 13,
    Clutter = 14,
    Applications = 15,
    Restore = 16,
    SpaceLens = 17,

    // Used to define array size below — must match last enum value
    LastItem = 17,
} AuroraType;

// IMPORTANT: Must stay in sync with Swift struct AuroraModel
// transitionValues must be exactly 8 elements (LastItem - SmartCare + 1)
typedef struct {
    float transitionValues[LastItem - SmartCare + 1];
    float size;
} AuroraModel;

#endif /* Header_h */
